<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-11-19 05:42
 */
interface EmployeeclosedaygroupstatusDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Employeeclosedaygroupstatus 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param employeeclosedaygroupstatu primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Employeeclosedaygroupstatus employeeclosedaygroupstatu
 	 */
	public function insert($employeeclosedaygroupstatu);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Employeeclosedaygroupstatus employeeclosedaygroupstatu
 	 */
	public function update($employeeclosedaygroupstatu);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByDay($value);

	public function queryByEmployeegroupid($value);

	public function queryByStatus($value);

	public function queryByUserid($value);

	public function queryBySysdate($value);

	public function queryByConditions($value);


	public function deleteByDay($value);

	public function deleteByEmployeegroupid($value);

	public function deleteByStatus($value);

	public function deleteByUserid($value);

	public function deleteBySysdate($value);

	public function deleteByConditions($value);


}
?>